/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class EditorOpener {
    private IEditorPart fEditor;

    IEditorPart open(Match match) throws PartInitException {
        IWorkbenchPage wbPage = SearchPlugin.getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(match, wbPage);
        }
        return this.showWithoutReuse(match, wbPage);
    }

    private IEditorPart showWithoutReuse(Match match, IWorkbenchPage wbPage) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)wbPage, (IFile)((IFile)match.getElement()), (boolean)false);
    }

    private IEditorPart showWithReuse(Match match, IWorkbenchPage wbPage) throws PartInitException {
        IFile file = (IFile)match.getElement();
        String editorID = this.getEditorID(file);
        return this.showInEditor(wbPage, file, editorID);
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return SearchPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        for (int i = 0; i < editorRefs.length; ++i) {
            if (!editor.equals(editorRefs[i].getEditor(false))) continue;
            return editorRefs[i].isPinned();
        }
        return false;
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IFile file, String editorId) throws PartInitException {
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        } else {
            boolean showsSameInputType;
            boolean isOpen = false;
            if (this.fEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    isOpen = this.fEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            boolean bl = showsSameInputType = this.fEditor != null && this.fEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)this.fEditor).setInput((IEditorInput)input);
                page.bringToTop((IWorkbenchPart)this.fEditor);
                editor = this.fEditor;
            } else {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)false);
                this.fEditor = editor instanceof IReusableEditor ? editor : null;
            }
        }
        return editor;
    }
}

