/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileOutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class RegistryCacheWriter {
    protected HashMap objectTable = null;
    protected MultiStatus problems = null;
    protected File cacheFile;

    public RegistryCacheWriter(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    private int addToObjectTable(Object object) {
        if (this.objectTable == null) {
            this.objectTable = new HashMap();
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    public void writeConfigurationElement(ConfigurationElement object, DataOutputStream out) {
        try {
            this.writeCachedStringOrNull(object.getName(), out);
            this.writeStringOrNull(object.getValue(), out);
            ConfigurationProperty[] properties = object.getProperties();
            int length = properties == null ? 0 : properties.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeConfigurationProperty(properties[i], out);
            }
            IConfigurationElement[] elements = object.getChildren();
            length = elements == null ? 0 : elements.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeConfigurationElement((ConfigurationElement)elements[i], out);
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ConfigruationElement"), ioe));
        }
    }

    public void writeConfigurationProperty(ConfigurationProperty object, DataOutputStream out) {
        try {
            this.writeCachedStringOrNull(object.getName(), out);
            this.writeStringOrNull(object.getValue(), out);
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ConfigurationProperty"), ioe));
        }
    }

    public void writeExtension(Extension object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            this.writeStringOrNull(object.getSimpleIdentifier(), out);
            this.writeBundleModel((Namespace)object.getParent(), out);
            this.writeStringOrNull(object.getName(), out);
            this.writeCachedStringOrNull(object.getExtensionPointIdentifier(), out);
            this.writeSubElements(object, out);
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "Extension"), ioe));
        }
    }

    private void writeCachedStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            int index = this.getFromObjectTable(string);
            if (index == -1) {
                this.addToObjectTable(string);
                out.writeByte(1);
                out.writeUTF(string);
            } else {
                out.writeByte(2);
                out.writeInt(index);
            }
        }
    }

    public void writeSubElements(Extension object, DataOutputStream out) throws IOException {
        IConfigurationElement[] subElements = object.getConfigurationElements();
        if (subElements == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeInt(out.size());
        out.writeInt(subElements.length);
        for (int i = 0; i < subElements.length; ++i) {
            this.writeConfigurationElement((ConfigurationElement)subElements[i], out);
        }
    }

    public void writeExtensionPoint(ExtensionPoint object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            this.writeStringOrNull(object.getSimpleIdentifier(), out);
            this.writeStringOrNull(object.getName(), out);
            this.writeStringOrNull(object.getSchema(), out);
            IExtension[] extensions = object.getExtensions();
            int length = extensions == null ? 0 : extensions.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeExtension((Extension)extensions[i], out);
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ExtensionPoint"), ioe));
        }
    }

    public void writeHeaderInformation(long registryStamp, DataOutputStream out) {
        try {
            out.writeInt(7);
            out.writeLong(InternalPlatform.getDefault().getStateTimeStamp());
            out.writeLong(registryStamp);
            InternalPlatform info = InternalPlatform.getDefault();
            out.writeUTF(info.getOS());
            out.writeUTF(info.getWS());
            out.writeUTF(info.getNL());
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "HeaderInformation"), ioe));
        }
    }

    public void writeBundleModel(Namespace object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            this.writeCachedStringOrNull(object.getUniqueIdentifier(), out);
            out.writeLong(object.getId());
            this.writeRegistry((ExtensionRegistry)object.getParent(), out);
            this.writeCachedStringOrNull(object.getHostIdentifier(), out);
            IExtensionPoint[] extensionPoints = object.getExtensionPoints();
            int length = extensionPoints == null ? 0 : extensionPoints.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeExtensionPoint((ExtensionPoint)extensionPoints[i], out);
            }
            IExtension[] extensions = object.getExtensions();
            length = extensions == null ? 0 : extensions.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeExtension((Extension)extensions[i], out);
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "Bundle"), ioe));
        }
    }

    public void writeCache(ExtensionRegistry object, long registryStamp, DataOutputStream out) {
        if (this.problems == null) {
            this.problems = new MultiStatus("org.eclipse.core.runtime", 1, Policy.bind("meta.registryCacheWriteProblems"), null);
        }
        this.writeHeaderInformation(registryStamp, out);
        this.writeRegistry(object, out);
    }

    public void writeRegistry(ExtensionRegistry object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            String[] ids = object.basicGetNamespaces();
            out.writeInt(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                this.writeBundleModel(object.basicGetNamespace(ids[i]), out);
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ExtensionRegisry"), ioe));
        }
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCache(ExtensionRegistry registry, long registryStamp) {
        registry.enterRead();
        SafeFileOutputStream safeOut = null;
        try {
            DataOutputStream out;
            block8: {
                safeOut = new SafeFileOutputStream(this.cacheFile);
                out = new DataOutputStream(safeOut);
                try {
                    this.writeCache(registry, registryStamp, out);
                    Object var7_6 = null;
                    RegistryCacheReader reader = registry.getCacheReader();
                    if (reader == null || !reader.hasFailed()) break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    RegistryCacheReader reader = registry.getCacheReader();
                    if (reader != null && reader.hasFailed()) {
                        safeOut.close(true);
                        throw throwable;
                    }
                    out.close();
                    throw throwable;
                }
                safeOut.close(true);
                return;
            }
            out.close();
            return;
        }
        catch (IOException e) {
            if (!InternalPlatform.DEBUG_REGISTRY) return;
            e.printStackTrace();
            return;
        }
        finally {
            registry.exitRead();
        }
    }

    public void saveCache(ExtensionRegistry registry) {
        this.saveCache(registry, 0L);
    }
}

