/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.link;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;

class LinkedModeManager {
    private static Map fManagers = new HashMap();
    private Stack fEnvironments = new Stack();
    private Listener fListener = new Listener();

    LinkedModeManager() {
    }

    public static boolean hasManager(IDocument document) {
        return fManagers.get(document) != null;
    }

    public static boolean hasManager(IDocument[] documents) {
        for (int i = 0; i < documents.length; ++i) {
            if (!LinkedModeManager.hasManager(documents[i])) continue;
            return true;
        }
        return false;
    }

    public static LinkedModeManager getLinkedManager(IDocument[] documents, boolean force) {
        int i;
        if (documents == null || documents.length == 0) {
            return null;
        }
        HashSet<LinkedModeManager> mgrs = new HashSet<LinkedModeManager>();
        LinkedModeManager mgr = null;
        for (i = 0; i < documents.length; ++i) {
            mgr = (LinkedModeManager)fManagers.get(documents[i]);
            if (mgr == null) continue;
            mgrs.add(mgr);
        }
        if (mgrs.size() > 1) {
            if (force) {
                Iterator it = mgrs.iterator();
                while (it.hasNext()) {
                    LinkedModeManager m = (LinkedModeManager)it.next();
                    m.closeAllEnvironments();
                }
            } else {
                return null;
            }
        }
        if (mgrs.size() == 0) {
            mgr = new LinkedModeManager();
        }
        for (i = 0; i < documents.length; ++i) {
            fManagers.put(documents[i], mgr);
        }
        return mgr;
    }

    public static void cancelManager(IDocument document) {
        LinkedModeManager mgr = (LinkedModeManager)fManagers.get(document);
        if (mgr != null) {
            mgr.closeAllEnvironments();
        }
    }

    private void left(LinkedModeModel model, int flags) {
        LinkedModeModel env;
        if (!this.fEnvironments.contains(model)) {
            return;
        }
        while (!this.fEnvironments.isEmpty() && (env = (LinkedModeModel)this.fEnvironments.pop()) != model) {
            env.exit(0);
        }
        if (this.fEnvironments.isEmpty()) {
            this.removeManager();
        }
    }

    private void closeAllEnvironments() {
        while (!this.fEnvironments.isEmpty()) {
            LinkedModeModel env = (LinkedModeModel)this.fEnvironments.pop();
            env.exit(0);
        }
        this.removeManager();
    }

    private void removeManager() {
        Iterator it = fManagers.keySet().iterator();
        while (it.hasNext()) {
            IDocument doc = (IDocument)it.next();
            if (fManagers.get(doc) != this) continue;
            it.remove();
        }
    }

    /*
     * Loose catch block
     */
    public boolean nestEnvironment(LinkedModeModel model, boolean force) {
        boolean bl;
        Assert.isNotNull(model);
        while (true) {
            if (!this.fEnvironments.isEmpty()) break block6;
            model.addLinkingListener(this.fListener);
            this.fEnvironments.push(model);
            bl = true;
            break;
        }
        catch (Throwable throwable) {
            Assert.isTrue(this.fEnvironments.size() > 0);
            throw throwable;
        }
        {
            LinkedModeModel top;
            block8: {
                block7: {
                    block6: {
                        Assert.isTrue(this.fEnvironments.size() > 0);
                        return bl;
                    }
                    top = (LinkedModeModel)this.fEnvironments.peek();
                    if (!model.canNestInto(top)) break block7;
                    model.addLinkingListener(this.fListener);
                    this.fEnvironments.push(model);
                    boolean bl2 = true;
                    Assert.isTrue(this.fEnvironments.size() > 0);
                    return bl2;
                }
                if (force) break block8;
                boolean bl3 = false;
                Assert.isTrue(this.fEnvironments.size() > 0);
                return bl3;
            }
            this.fEnvironments.pop();
            top.exit(0);
            continue;
        }
    }

    public LinkedModeModel getTopEnvironment() {
        if (this.fEnvironments.isEmpty()) {
            return null;
        }
        return (LinkedModeModel)this.fEnvironments.peek();
    }

    private class Listener
    implements ILinkedModeListener {
        private Listener() {
        }

        public void left(LinkedModeModel model, int flags) {
            LinkedModeManager.this.left(model, flags);
        }

        public void suspend(LinkedModeModel model) {
        }

        public void resume(LinkedModeModel model, int flags) {
        }
    }
}

