/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;

public class SynchronizeParticipantDescriptor
implements ISynchronizeParticipantDescriptor {
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_ICON = "icon";
    public static final String ATT_CLASS = "class";
    private static final String ATT_TYPE = "type";
    private static final String ATT_PERSISTENT = "persistent";
    private String label;
    private String className;
    private String type;
    private String id;
    private boolean persistent;
    private ImageDescriptor imageDescriptor;
    private String description;
    private IConfigurationElement configElement;

    public SynchronizeParticipantDescriptor(IConfigurationElement e, String desc) throws CoreException {
        this.configElement = e;
        this.description = desc;
        this.loadFromExtension();
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String iconName = this.configElement.getAttribute(ATT_ICON);
        if (iconName == null) {
            return null;
        }
        this.imageDescriptor = TeamUIPlugin.getImageDescriptorFromExtension(this.configElement.getDeclaringExtension(), iconName);
        return this.imageDescriptor;
    }

    public String getName() {
        return this.label;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    private void loadFromExtension() throws CoreException {
        String identifier = this.configElement.getAttribute(ATT_ID);
        this.label = this.configElement.getAttribute(ATT_NAME);
        this.className = this.configElement.getAttribute(ATT_CLASS);
        this.type = this.configElement.getAttribute(ATT_TYPE);
        String persistentString = this.configElement.getAttribute(ATT_PERSISTENT);
        this.persistent = persistentString == null ? true : Boolean.valueOf(persistentString);
        if (this.label == null || this.className == null || identifier == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, "Invalid extension (missing label or class name): " + identifier, null));
        }
        this.id = identifier;
    }

    public String toString() {
        return "Synchronize Participant(" + this.getId() + ")";
    }
}

