/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetSynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.PageBook;

public class ChangesSection
extends Composite {
    private ISynchronizeParticipant participant;
    private SyncInfoSetSynchronizePage page;
    private FormToolkit forms;
    private PageBook changesSectionContainer;
    private Composite filteredContainer;
    private Viewer changesViewer;
    private boolean showingError;
    private SynchronizePageActionGroup changedListener = new SynchronizePageActionGroup(){

        public void modelChanged(ISynchronizeModelElement root) {
            ChangesSection.this.calculateDescription();
        }
    };
    private ISyncInfoSetChangeListener subscriberListener = new ISyncInfoSetChangeListener(){

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
            ChangesSection.this.calculateDescription();
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        }
    };
    private ISyncInfoSetChangeListener outputSetListener = new ISyncInfoSetChangeListener(){

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
            ChangesSection.this.calculateDescription();
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
            ChangesSection.this.calculateDescription();
        }
    };
    private ISynchronizePageConfiguration configuration;

    public ChangesSection(Composite parent, SyncInfoSetSynchronizePage page, ISynchronizePageConfiguration configuration) {
        super(parent, 0);
        this.page = page;
        this.configuration = configuration;
        this.participant = configuration.getParticipant();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.setLayoutData(data);
        this.forms = new FormToolkit(parent.getDisplay());
        this.forms.setBackground(this.getBackgroundColor());
        HyperlinkGroup group = this.forms.getHyperlinkGroup();
        group.setBackground(this.getBackgroundColor());
        this.changesSectionContainer = new PageBook((Composite)this, 0);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.changesSectionContainer.setLayoutData((Object)data);
    }

    public Composite getComposite() {
        return this.changesSectionContainer;
    }

    public void setViewer(Viewer viewer) {
        this.changesViewer = viewer;
        this.calculateDescription();
        this.configuration.addActionContribution(this.changedListener);
        this.getWorkingSetSyncInfoSet().addSyncSetChangedListener(this.subscriberListener);
        this.getSyncInfoTree().addSyncSetChangedListener(this.outputSetListener);
    }

    private void calculateDescription() {
        SyncInfoTree syncInfoTree = this.getSyncInfoTree();
        if (syncInfoTree.getErrors().length > 0) {
            if (!this.showingError) {
                TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ChangesSection.this.changesSectionContainer.isDisposed()) {
                            return;
                        }
                        if (ChangesSection.this.filteredContainer != null) {
                            ChangesSection.this.filteredContainer.dispose();
                            ChangesSection.this.filteredContainer = null;
                        }
                        ChangesSection.this.filteredContainer = ChangesSection.this.getErrorComposite((Composite)ChangesSection.this.changesSectionContainer);
                        ChangesSection.this.changesSectionContainer.showPage((Control)ChangesSection.this.filteredContainer);
                        ChangesSection.this.showingError = true;
                    }
                });
            }
            return;
        }
        this.showingError = false;
        if (syncInfoTree.size() == 0) {
            TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ChangesSection.this.changesSectionContainer.isDisposed()) {
                        return;
                    }
                    if (ChangesSection.this.filteredContainer != null) {
                        ChangesSection.this.filteredContainer.dispose();
                        ChangesSection.this.filteredContainer = null;
                    }
                    ChangesSection.this.filteredContainer = ChangesSection.this.getEmptyChangesComposite((Composite)ChangesSection.this.changesSectionContainer);
                    ChangesSection.this.changesSectionContainer.showPage((Control)ChangesSection.this.filteredContainer);
                }
            });
        } else {
            TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ChangesSection.this.filteredContainer != null) {
                        ChangesSection.this.filteredContainer.dispose();
                        ChangesSection.this.filteredContainer = null;
                    }
                    Control control = ChangesSection.this.changesViewer.getControl();
                    if (!ChangesSection.this.changesSectionContainer.isDisposed() && !control.isDisposed()) {
                        ChangesSection.this.changesSectionContainer.showPage(control);
                    }
                }
            });
        }
    }

    private boolean isThreeWay() {
        return "three-way".equals(this.configuration.getComparisonType());
    }

    private Composite getEmptyChangesComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        if (!this.isThreeWay()) {
            this.createDescriptionLabel(composite, Policy.bind("ChangesSection.noChanges", this.participant.getName()));
            return composite;
        }
        SyncInfoSet workingSet = this.getWorkingSetSyncInfoSet();
        SyncInfoTree filteredSet = this.getSyncInfoTree();
        int changesInWorkingSet = workingSet.size();
        int changesInFilter = filteredSet.size();
        long outgoingChanges = workingSet.countFor(4, 12);
        long incomingChanges = workingSet.countFor(8, 12);
        if (changesInFilter == 0 && changesInWorkingSet != 0) {
            final int newMode = outgoingChanges != 0L ? 2 : 1;
            long numChanges = outgoingChanges != 0L ? outgoingChanges : incomingChanges;
            StringBuffer text = new StringBuffer();
            text.append(Policy.bind("ChangesSection.filterHides", Utils.modeToString(this.configuration.getMode())));
            if (numChanges > 1L) {
                text.append(Policy.bind("ChangesSection.filterHidesPlural", Long.toString(numChanges), Utils.modeToString(newMode)));
            } else {
                text.append(Policy.bind("ChangesSection.filterHidesSingular", Long.toString(numChanges), Utils.modeToString(newMode)));
            }
            Label warning = new Label(composite, 0);
            warning.setImage(TeamUIPlugin.getPlugin().getImage("ovr/warning_co.gif"));
            Hyperlink link = this.forms.createHyperlink(composite, Policy.bind("ChangesSection.filterChange", Utils.modeToString(newMode)), 64);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ChangesSection.this.configuration.setMode(newMode);
                }
            });
            this.forms.getHyperlinkGroup().add(link);
            this.createDescriptionLabel(composite, text.toString());
        } else {
            this.createDescriptionLabel(composite, Policy.bind("ChangesSection.noChanges", this.participant.getName()));
        }
        return composite;
    }

    private Label createDescriptionLabel(Composite parent, String text) {
        Label description = new Label(parent, 64);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 100;
        description.setLayoutData((Object)data);
        description.setText(text);
        description.setBackground(this.getBackgroundColor());
        return description;
    }

    public void dispose() {
        super.dispose();
        this.forms.dispose();
        this.configuration.removeActionContribution(this.changedListener);
        this.getWorkingSetSyncInfoSet().removeSyncSetChangedListener(this.subscriberListener);
        this.getSyncInfoTree().removeSyncSetChangedListener(this.outputSetListener);
    }

    private Composite getErrorComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        Hyperlink link = new Hyperlink(composite, 64);
        link.setText(Policy.bind("ChangesSection.8"));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ChangesSection.this.showErrors();
            }
        });
        link.setBackground(this.getBackgroundColor());
        link.setUnderlined(true);
        link = new Hyperlink(composite, 64);
        link.setText(Policy.bind("ChangesSection.9"));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ChangesSection.this.page.reset();
            }
        });
        link.setBackground(this.getBackgroundColor());
        link.setUnderlined(true);
        this.createDescriptionLabel(composite, Policy.bind("ChangesSection.10", this.participant.getName()));
        return composite;
    }

    void showErrors() {
        ITeamStatus[] status = this.getSyncInfoTree().getErrors();
        String title = Policy.bind("ChangesSection.11");
        if (status.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)status[0].getMessage(), (IStatus)status[0]);
        } else {
            MultiStatus multi = new MultiStatus("org.eclipse.team.ui", 0, (IStatus[])status, Policy.bind("ChangesSection.12"), null);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)multi);
        }
    }

    protected Color getBackgroundColor() {
        return this.getShell().getDisplay().getSystemColor(25);
    }

    private SyncInfoTree getSyncInfoTree() {
        return (SyncInfoTree)this.configuration.getProperty("org.eclipse.team.ui.P_SYNC_INFO_SET");
    }

    private SyncInfoSet getWorkingSetSyncInfoSet() {
        return (SyncInfoSet)this.configuration.getProperty("org.eclipse.team.ui.P_WORKING_SET_SYNC_INFO_SET");
    }
}

