/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class Project
extends Container
implements IProject {
    protected Project(IPath path, Workspace container) {
        super(path, container);
    }

    protected MultiStatus basicSetDescription(ProjectDescription description, int updateFlags) {
        String message = Policy.bind("resources.projectDesc");
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 568, message, null);
        ProjectDescription current = this.internalGetDescription();
        current.setComment(description.getComment());
        current.setBuildSpec(description.getBuildSpec(true));
        boolean flushOrder = false;
        Object[] oldReferences = current.getReferencedProjects();
        Object[] newReferences = description.getReferencedProjects();
        if (!Arrays.equals(oldReferences, newReferences)) {
            current.setReferencedProjects((IProject[])newReferences);
            flushOrder = true;
        }
        if (!Arrays.equals(oldReferences = current.getDynamicReferences(), newReferences = description.getDynamicReferences())) {
            current.setDynamicReferences((IProject[])newReferences);
            flushOrder = true;
        }
        if (flushOrder) {
            this.workspace.flushBuildOrder();
        }
        if ((updateFlags & 0x40) == 0) {
            this.workspace.getNatureManager().configureNatures(this, current, description, result);
        } else {
            current.setNatureIds(description.getNatureIds(false));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(int kind, String builderName, Map args, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule;
        block5: {
            rule = this.workspace.getRuleFactory().buildRule();
            try {
                block6: {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    int flags = this.getFlags(info);
                    if (!this.exists(flags, true)) break block6;
                    if (this.isOpen(flags)) break block7;
                }
                Object var9_8 = null;
                if (!this.workspace.getElementTree().isImmutable()) break block5;
                this.workspace.newWorkingTree();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(rule, false, null);
                throw throwable;
            }
        }
        this.workspace.endOperation(rule, false, null);
        {
            block7: {
                return;
            }
            this.workspace.beginOperation(true);
            this.workspace.aboutToBuild();
            this.workspace.getBuildManager().build(this, kind, builderName, args, monitor);
            this.workspace.broadcastChanges(16, false);
        }
        Object var9_9 = null;
        if (this.workspace.getElementTree().isImmutable()) {
            this.workspace.newWorkingTree();
        }
        this.workspace.endOperation(rule, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        ISchedulingRule rule;
        block5: {
            rule = this.workspace.getRuleFactory().buildRule();
            try {
                block6: {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    int flags = this.getFlags(info);
                    if (!this.exists(flags, true)) break block6;
                    if (this.isOpen(flags)) break block7;
                }
                Object var7_6 = null;
                if (!this.workspace.getElementTree().isImmutable()) break block5;
                this.workspace.newWorkingTree();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(rule, false, null);
                throw throwable;
            }
        }
        this.workspace.endOperation(rule, false, null);
        {
            block7: {
                return;
            }
            this.workspace.beginOperation(true);
            this.workspace.aboutToBuild();
            this.workspace.getBuildManager().build(this, trigger, monitor);
            this.workspace.broadcastChanges(16, false);
        }
        Object var7_7 = null;
        if (this.workspace.getElementTree().isImmutable()) {
            this.workspace.newWorkingTree();
        }
        this.workspace.endOperation(rule, false, null);
    }

    public void checkAccessible(int flags) throws CoreException {
        super.checkAccessible(flags);
        if (!this.isOpen(flags)) {
            String message = Policy.bind("resources.mustBeOpen", this.getFullPath().toString());
            throw new ResourceException(372, this.getFullPath(), message, null);
        }
    }

    protected void checkDescription(IProject project, IProjectDescription desc, boolean moving) throws CoreException {
        IPath location = desc.getLocation();
        if (location == null) {
            return;
        }
        String message = Policy.bind("resources.invalidProjDesc");
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 77, message, null);
        status.merge(this.workspace.validateName(desc.getName(), 4));
        if (moving) {
            IPath sourceLocation = this.internalGetDescription().getLocation();
            if (sourceLocation == null || !sourceLocation.equals(location)) {
                status.merge(this.workspace.validateProjectLocation(project, location));
            }
        } else {
            status.merge(this.workspace.validateProjectLocation(project, location));
        }
        if (!status.isOK()) {
            throw new ResourceException((IStatus)status);
        }
        desc.setLocation((IPath)new Path(location.toFile().getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String msg = Policy.bind("resources.closing.1", this.getFullPath().toString());
            monitor.beginTask(msg, Policy.totalWork);
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(1, this));
                this.workspace.prepareOperation(rule, monitor);
                ResourceInfo info = this.getResourceInfo(false, false);
                int flags = this.getFlags(info);
                this.checkExists(flags, true);
                monitor.subTask(msg);
                if (!this.isOpen(flags)) {
                    return;
                }
                this.workspace.beginOperation(true);
                this.workspace.flushBuildOrder();
                IProgressMonitor sub = Policy.subMonitorFor(monitor, Policy.opWork / 2, 2);
                IStatus saveStatus = this.workspace.getSaveManager().save(3, this, sub);
                this.internalClose();
                monitor.worked(Policy.opWork / 2);
                if (saveStatus != null && !saveStatus.isOK()) {
                    throw new ResourceException(saveStatus);
                }
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
            finally {
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void copy(IProjectDescription destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(destination);
        this.internalCopy(destination, updateFlags, monitor);
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        if (destination.segmentCount() == 1) {
            String projectName = destination.segment(0);
            IProjectDescription desc = this.getDescription();
            desc.setName(projectName);
            desc.setLocation(null);
            this.internalCopy(desc, updateFlags, monitor);
        } else {
            this.checkCopyRequirements(destination, 4, updateFlags);
        }
    }

    protected void copyMetaArea(IProject source, IProject destination, IProgressMonitor monitor) throws CoreException {
        File oldMetaArea = this.workspace.getMetaArea().locationFor(source).toFile();
        File newMetaArea = this.workspace.getMetaArea().locationFor(destination).toFile();
        this.getLocalManager().getStore().copy(oldMetaArea, newMetaArea, 2, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Policy.bind("resources.create"), Policy.totalWork);
            this.checkValidPath(this.path, 4, false);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                this.workspace.prepareOperation(rule, monitor);
                this.checkDoesNotExist();
                if (description != null) {
                    this.checkDescription(this, description, false);
                }
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(8, this));
                this.workspace.beginOperation(true);
                this.workspace.createResource(this, false);
                this.workspace.getMetaArea().create(this);
                ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, true);
                ProjectDescription desc = description == null ? new ProjectDescription() : (ProjectDescription)((ProjectDescription)description).clone();
                desc.setName(this.getName());
                info.setDescription(desc);
                try {
                    if (this.getLocalManager().hasSavedProject(this)) {
                        this.updateDescription();
                        this.workspace.getMetaArea().writePrivateDescription(this);
                    } else {
                        this.writeDescription(1);
                    }
                }
                catch (CoreException e) {
                    this.workspace.deleteResource(this);
                    throw e;
                }
                info.setModificationStamp(-1L);
                this.workspace.getSaveManager().requestSnapshot();
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
            finally {
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void create(IProgressMonitor monitor) throws CoreException {
        this.create(null, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags, monitor);
    }

    protected void fixupAfterMoveSource() throws CoreException {
        this.workspace.deleteResource(this);
    }

    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags |= deleteContent ? 4 : 8, monitor);
    }

    public String getDefaultCharset(boolean checkImplicit) throws CoreException {
        if (!this.exists()) {
            return checkImplicit ? ResourcesPlugin.getEncoding() : null;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), checkImplicit);
    }

    public IProjectDescription getDescription() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        return (IProjectDescription)((ProjectInfo)info).getDescription().clone();
    }

    public IProjectNature getNature(String natureID) throws CoreException {
        ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        IProjectNature nature = info.getNature(natureID);
        if (nature == null) {
            if (!this.hasNature(natureID)) {
                return null;
            }
            nature = this.workspace.getNatureManager().createNature(this, natureID);
            info.setNature(natureID, nature);
        }
        return nature;
    }

    public IContainer getParent() {
        return this.workspace.getRoot();
    }

    public IPath getPluginWorkingLocation(IPluginDescriptor plugin) {
        if (plugin == null) {
            return null;
        }
        return this.getWorkingLocation(plugin.getUniqueIdentifier());
    }

    public IPath getWorkingLocation(String id) {
        if (id == null || !this.exists()) {
            return null;
        }
        IPath result = this.workspace.getMetaArea().getWorkingLocation(this, id);
        result.toFile().mkdirs();
        return result;
    }

    public IProject getProject() {
        return this;
    }

    public IPath getProjectRelativePath() {
        return Path.EMPTY;
    }

    public IPath getRawLocation() {
        ProjectDescription description = this.internalGetDescription();
        return description == null ? null : description.getLocation();
    }

    public IProject[] getReferencedProjects() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        return ((ProjectInfo)info).getDescription().getAllReferences(true);
    }

    public IProject[] getReferencingProjects() {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>(projects.length);
        block0: for (int i = 0; i < projects.length; ++i) {
            ProjectDescription description;
            Project project = (Project)projects[i];
            if (!project.isAccessible() || (description = project.internalGetDescription()) == null) continue;
            IProject[] references = description.getAllReferences(false);
            for (int j = 0; j < references.length; ++j) {
                if (!references[j].equals(this)) continue;
                result.add(projects[i]);
                continue block0;
            }
        }
        return result.toArray(new IProject[result.size()]);
    }

    public int getType() {
        return 4;
    }

    public boolean hasNature(String natureID) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        ProjectDescription desc = this.internalGetDescription();
        if (desc == null) {
            this.checkAccessible(-1);
        }
        return desc.hasNature(natureID);
    }

    protected void internalClose() throws CoreException {
        this.workspace.flushBuildOrder();
        this.getMarkerManager().removeMarkers(this, 2);
        IResource[] members = this.members(3);
        for (int i = 0; i < members.length; ++i) {
            Resource member = (Resource)members[i];
            this.workspace.deleteResource(member);
        }
        ResourceInfo info = this.getResourceInfo(false, true);
        info.clear(1);
        info.clearSessionProperties();
        info.setModificationStamp(-1L);
        info.setSyncInfo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCopy(IProjectDescription destDesc, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.copying", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            String destName = destDesc.getName();
            IPath destPath = new Path(destName).makeAbsolute();
            Project destination = (Project)this.workspace.getRoot().getProject(destName);
            ISchedulingRule rule = this.workspace.getRuleFactory().copyRule(this, destination);
            try {
                this.workspace.prepareOperation(rule, monitor);
                this.assertCopyRequirements(destPath, 4, updateFlags);
                this.checkDescription(destination, destDesc, false);
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(4, this, destination, updateFlags));
                this.workspace.beginOperation(true);
                this.getLocalManager().refresh(this, 2, true, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
                this.getPropertyManager().closePropertyStore(this);
                this.copyMetaArea(this, destination, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                this.internalCopyProjectOnly(destination, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                destination.internalSetDescription(destDesc, false);
                message = Policy.bind("resources.copyProblem");
                MultiStatus problems = new MultiStatus("org.eclipse.core.resources", 566, message, null);
                IResource[] children = this.members(2);
                int childCount = children.length;
                int childWork = childCount > 1 ? Policy.opWork * 50 / 100 / (childCount - 1) : 0;
                for (int i = 0; i < childCount; ++i) {
                    IResource child = children[i];
                    if (this.isProjectDescriptionFile(child)) continue;
                    try {
                        child.copy(destPath.append(child.getName()), updateFlags, Policy.subMonitorFor(monitor, childWork));
                        continue;
                    }
                    catch (CoreException e) {
                        problems.merge(e.getStatus());
                    }
                }
                try {
                    destination.writeDescription(1);
                }
                catch (CoreException e) {
                    try {
                        destination.delete((updateFlags & 1) != 0, null);
                    }
                    catch (CoreException e2) {
                        // empty catch block
                    }
                    throw e;
                }
                monitor.worked(Policy.opWork * 10 / 100);
                monitor.subTask(Policy.bind("resources.updating"));
                this.getLocalManager().refresh(destination, 2, true, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                if (!problems.isOK()) {
                    throw new ResourceException((IStatus)problems);
                }
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
            finally {
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void internalCopyProjectOnly(IResource destination, IProgressMonitor monitor) throws CoreException {
        this.getPropertyManager().closePropertyStore(this);
        this.workspace.copyTree(this, destination.getFullPath(), 0, 0, false);
        this.getPropertyManager().copy(this, destination, 0);
        ProjectInfo info = (ProjectInfo)((Resource)destination).getResourceInfo(false, true);
        info.setBuilders(null);
        info.clearNatures();
        info.setMarkers(null);
        info.clearSessionProperties();
    }

    public ProjectDescription internalGetDescription() {
        ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, false);
        if (info == null) {
            return null;
        }
        return info.getDescription();
    }

    void internalSetDescription(IProjectDescription value, boolean incrementContentId) {
        ResourceInfo info = this.getResourceInfo(false, true);
        ((ProjectInfo)info).setDescription((ProjectDescription)value);
        if (incrementContentId) {
            info.incrementContentId();
            if (info.getModificationStamp() != -1L) {
                this.workspace.updateModificationStamp(info);
            }
        }
    }

    public void internalSetLocal(boolean flag, int depth) throws CoreException {
        if (depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(this, false);
        for (int i = 0; i < children.length; ++i) {
            ((Resource)children[i]).internalSetLocal(flag, depth);
        }
    }

    public boolean isAccessible() {
        return this.isOpen();
    }

    public boolean isLocal(int depth) {
        return this.isLocal(-1, depth);
    }

    public boolean isLocal(int flags, int depth) {
        if (depth == 0) {
            return true;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(this, false);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isLocal(depth)) continue;
            return false;
        }
        return true;
    }

    public boolean isNatureEnabled(String natureId) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        return this.workspace.getNatureManager().isNatureEnabled(this, natureId);
    }

    public boolean isOpen() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.isOpen(this.getFlags(info));
    }

    public boolean isOpen(int flags) {
        return flags != -1 && ResourceInfo.isSet(flags, 1);
    }

    protected boolean isProjectDescriptionFile(IResource resource) {
        return resource.getType() == 1 && resource.getFullPath().segmentCount() == 2 && resource.getName().equals(".project");
    }

    public void move(IProjectDescription destination, boolean force, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(destination);
        this.move(destination, force ? 1 : 0, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(description);
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.moving", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            IProject destination = this.workspace.getRoot().getProject(description.getName());
            ISchedulingRule rule = this.workspace.getRuleFactory().moveRule(this, destination);
            try {
                this.workspace.prepareOperation(rule, monitor);
                if (!this.getName().equals(description.getName())) {
                    IPath destPath = Path.ROOT.append(description.getName());
                    this.assertMoveRequirements(destPath, 4, updateFlags);
                }
                this.checkDescription(destination, description, true);
                this.workspace.beginOperation(true);
                message = Policy.bind("resources.moveProblem");
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 4, message, null);
                WorkManager workManager = this.workspace.getWorkManager();
                ResourceTree tree = new ResourceTree(workManager.getLock(), status, updateFlags);
                IMoveDeleteHook hook = this.workspace.getMoveDeleteHook();
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(64, this, destination, updateFlags));
                int depth = 0;
                try {
                    depth = workManager.beginUnprotected();
                    if (!hook.moveProject(tree, this, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2))) {
                        tree.standardMoveProject(this, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2));
                    }
                }
                finally {
                    workManager.endUnprotected(depth);
                }
                tree.makeInvalid();
                if (!tree.getStatus().isOK()) {
                    throw new ResourceException(tree.getStatus());
                }
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
            finally {
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String msg = Policy.bind("resources.opening.1", this.getFullPath().toString());
            monitor.beginTask(msg, Policy.totalWork);
            monitor.subTask(msg);
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                this.workspace.prepareOperation(rule, monitor);
                ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, false);
                int flags = this.getFlags(info);
                this.checkExists(flags, true);
                if (this.isOpen(flags)) {
                    return;
                }
                this.workspace.beginOperation(true);
                this.workspace.flushBuildOrder();
                info = (ProjectInfo)this.getResourceInfo(false, true);
                info.set(1);
                if (info.isSet(16)) {
                    this.workspace.getSaveManager().restore(this, Policy.subMonitorFor(monitor, Policy.opWork * 30 / 100));
                } else {
                    info.set(16);
                    this.reconcileLinks(info.getDescription());
                    this.workspace.updateModificationStamp(info);
                }
                this.startup();
                monitor.worked(Policy.opWork * 20 / 100);
                this.refreshLocal(2, Policy.subMonitorFor(monitor, Policy.opWork * 50 / 100));
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
            finally {
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        finally {
            monitor.done();
        }
    }

    public IStatus reconcileLinks(ProjectDescription newDescription) {
        HashMap newLinks = newDescription.getLinks();
        IResource[] children = null;
        try {
            children = this.members();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        String msg = Policy.bind("links.errorLinkReconcile");
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 76, msg, null);
        for (int i = 0; i < children.length; ++i) {
            Resource oldLink = (Resource)children[i];
            if (!oldLink.isLinked()) continue;
            LinkDescription newLink = null;
            if (newLinks != null) {
                newLink = (LinkDescription)newLinks.get(oldLink.getName());
            }
            if (newLink != null && newLink.getLocation().equals(oldLink.getLocation()) && newLink.getType() == oldLink.getType()) continue;
            try {
                oldLink.delete(0, null);
                continue;
            }
            catch (CoreException e) {
                status.merge(e.getStatus());
            }
        }
        if (newLinks == null) {
            return status;
        }
        Iterator it = newLinks.values().iterator();
        while (it.hasNext()) {
            LinkDescription newLink = (LinkDescription)it.next();
            IResource existing = this.findMember(newLink.getName());
            if (existing != null) {
                if (existing.isLinked()) continue;
                status.add((IStatus)new ResourceStatus(367, existing.getFullPath(), msg));
                continue;
            }
            try {
                Resource toLink = newLink.getType() == 1 ? (Resource)((Object)this.getFile(newLink.getName())) : (Resource)((Object)this.getFolder(newLink.getName()));
                toLink.createLink(newLink.getLocation(), 16, null);
            }
            catch (CoreException e) {
                status.merge(e.getStatus());
            }
        }
        return status;
    }

    protected void renameMetaArea(IProject source, IProject destination, IProgressMonitor monitor) throws CoreException {
        File oldMetaArea = this.workspace.getMetaArea().locationFor(source).toFile();
        File newMetaArea = this.workspace.getMetaArea().locationFor(destination).toFile();
        this.getLocalManager().getStore().move(oldMetaArea, newMetaArea, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Policy.bind("resources.setDesc"), Policy.totalWork);
            IWorkspaceRoot rule = this.workspace.getRoot();
            try {
                this.workspace.prepareOperation(rule, monitor);
                ResourceInfo info = this.getResourceInfo(false, false);
                this.checkAccessible(this.getFlags(info));
                ProjectDescription oldDescription = this.internalGetDescription();
                ProjectDescription newDescription = (ProjectDescription)description;
                boolean hasPublicChanges = oldDescription.hasPublicChanges(newDescription);
                boolean hasPrivateChanges = oldDescription.hasPrivateChanges(newDescription);
                if (!hasPublicChanges && !hasPrivateChanges) {
                    return;
                }
                this.checkDescription(this, newDescription, false);
                boolean hadSavedDescription = true;
                if ((updateFlags & 1) == 0 && (hadSavedDescription = this.getLocalManager().hasSavedProject(this)) && !this.getLocalManager().isDescriptionSynchronized(this)) {
                    String message = Policy.bind("resources.projectDescSync", this.getName());
                    throw new ResourceException(274, this.getFullPath(), message, null);
                }
                if (!hadSavedDescription) {
                    hadSavedDescription = this.workspace.getMetaArea().hasSavedProject(this);
                }
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                this.workspace.beginOperation(true);
                MultiStatus status = this.basicSetDescription(newDescription, updateFlags);
                if (hadSavedDescription && !status.isOK()) {
                    throw new CoreException((IStatus)status);
                }
                this.writeDescription(oldDescription, updateFlags, hasPublicChanges, hasPrivateChanges);
                info = this.getResourceInfo(false, true);
                info.incrementContentId();
                this.workspace.updateModificationStamp(info);
                if (!hadSavedDescription) {
                    String msg = Policy.bind("resources.missingProjectMetaRepaired", this.getName());
                    status.merge((IStatus)new ResourceStatus(234, this.getFullPath(), msg));
                }
                if (!status.isOK()) {
                    throw new CoreException((IStatus)status);
                }
            }
            finally {
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setDescription(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        this.setDescription(description, 2, monitor);
    }

    protected void startup() throws CoreException {
        if (!this.isOpen()) {
            return;
        }
        this.workspace.broadcastEvent(LifecycleEvent.newEvent(32, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resource.touch", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                this.workspace.prepareOperation(rule, monitor);
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                this.workspace.beginOperation(true);
                super.touch(Policy.subMonitorFor(monitor, Policy.opWork));
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
            finally {
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDescription() throws CoreException {
        if (ProjectDescription.isWriting) {
            return;
        }
        ProjectDescription.isReading = true;
        try {
            this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
            ProjectDescription description = this.getLocalManager().read(this, false);
            if (this.isOpen()) {
                this.reconcileLinks(description);
            }
            this.internalSetDescription(description, true);
        }
        finally {
            ProjectDescription.isReading = false;
        }
    }

    public void writeDescription(int updateFlags) throws CoreException {
        this.writeDescription(this.internalGetDescription(), updateFlags, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDescription(IProjectDescription description, int updateFlags, boolean hasPublicChanges, boolean hasPrivateChanges) throws CoreException {
        if (ProjectDescription.isReading) {
            return;
        }
        ProjectDescription.isWriting = true;
        try {
            this.getLocalManager().internalWrite(this, description, updateFlags, hasPublicChanges, hasPrivateChanges);
        }
        finally {
            ProjectDescription.isWriting = false;
        }
    }
}

