/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSDecoratorConfiguration;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSDecoratorPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button imageShowDirty;
    private Button imageShowHasRemote;
    private Button imageShowAdded;
    private Button imageShowNewResource;
    private Text fileTextFormat;
    private Text fileTextFormatExample;
    private Text folderTextFormat;
    private Text folderTextFormatExample;
    private Text projectTextFormat;
    private Text projectTextFormatExample;
    private Text dirtyFlag;
    private Text addedFlag;
    private Button showDirty;

    public CVSDecoratorPreferencesPage() {
        this.setDescription(Policy.bind("CVSDecoratorPreferencesPage.description"));
    }

    protected TextPair createFormatEditorControl(Composite composite, String title, String buttonText, final Map supportedBindings) {
        this.createLabel(composite, title, 1);
        Text format = new Text(composite, 2048);
        format.setLayoutData((Object)new GridData(768));
        format.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CVSDecoratorPreferencesPage.this.updateExamples();
            }
        });
        Button b = new Button(composite, 0);
        b.setText(buttonText);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, b.computeSize((int)-1, (int)-1, (boolean)true).x);
        b.setLayoutData((Object)data);
        final Text formatToInsert = format;
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CVSDecoratorPreferencesPage.this.addVariables(formatToInsert, supportedBindings);
            }
        });
        this.createLabel(composite, Policy.bind("Example__1"), 1);
        Text example = new Text(composite, 2048);
        example.setEditable(false);
        example.setLayoutData((Object)new GridData(768));
        this.createLabel(composite, "", 1);
        return new TextPair(format, example);
    }

    protected void updateExamples() {
        String example = "";
        HashMap<String, String> bindings = new HashMap<String, String>();
        try {
            CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:username@host.acme.org:/home/cvsroot");
            bindings.put("tag", "v2_0");
            bindings.put("keyword", Command.KSUBST_TEXT.getShortDisplayText());
            bindings.put("revision", "1.34");
            bindings.put("dirty_flag", this.dirtyFlag.getText());
            bindings.put("added_flag", this.addedFlag.getText());
            bindings.put("host", location.getHost());
            bindings.put("method", location.getMethod().getName());
            bindings.put("user", location.getUsername());
            bindings.put("root", location.getRootDirectory());
            bindings.put("repository", "org.eclipse.project1");
        }
        catch (CVSException e) {
            example = e.getMessage();
        }
        bindings.put("name", "file.txt");
        this.setTextFormatExample(bindings);
        bindings.remove("name");
        bindings.put("name", "folder");
        this.setFolderFormatExample(bindings);
        bindings.remove("name");
        bindings.put("name", "Project");
        this.setProjectFormatExample(bindings);
    }

    protected Control createContents(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("Text_Labels_12"));
        tabItem.setControl(this.createTextDecoratorPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("Icon_Overlays_24"));
        tabItem.setControl(this.createIconDecoratorPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("CVSDecoratorPreferencesPage.generalTabFolder"));
        tabItem.setControl(this.createGeneralDecoratorPage((Composite)tabFolder));
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)tabFolder, (String)"org.eclipse.team.cvs.ui.decorators_preference_page_context");
        Dialog.applyDialogFont((Control)parent);
        return tabFolder;
    }

    private Control createTextDecoratorPage(Composite parent) {
        Composite fileTextGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        fileTextGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        fileTextGroup.setLayoutData((Object)data);
        this.createLabel(fileTextGroup, Policy.bind("Select_the_format_for_file,_folders,_and_project_text_labels__13"), 3);
        TextPair format = this.createFormatEditorControl(fileTextGroup, Policy.bind("&File_Format__14"), Policy.bind("Add_&Variables_15"), this.getFileBindingDescriptions());
        this.fileTextFormat = format.t1;
        this.fileTextFormatExample = format.t2;
        format = this.createFormatEditorControl(fileTextGroup, Policy.bind("F&older_Format__16"), Policy.bind("Add_Varia&bles_17"), this.getFolderBindingDescriptions());
        this.folderTextFormat = format.t1;
        this.folderTextFormatExample = format.t2;
        format = this.createFormatEditorControl(fileTextGroup, Policy.bind("&Project_Format__18"), Policy.bind("Add_Variable&s_19"), this.getFolderBindingDescriptions());
        this.projectTextFormat = format.t1;
        this.projectTextFormatExample = format.t2;
        this.createLabel(fileTextGroup, Policy.bind("&Label_decoration_for_outgoing__20"), 1);
        this.dirtyFlag = new Text(fileTextGroup, 2048);
        this.dirtyFlag.setLayoutData((Object)new GridData(768));
        this.dirtyFlag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CVSDecoratorPreferencesPage.this.updateExamples();
            }
        });
        this.createLabel(fileTextGroup, "", 1);
        this.createLabel(fileTextGroup, Policy.bind("Label_decorat&ion_for_added__22"), 1);
        this.addedFlag = new Text(fileTextGroup, 2048);
        this.addedFlag.setLayoutData((Object)new GridData(768));
        this.addedFlag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CVSDecoratorPreferencesPage.this.updateExamples();
            }
        });
        return fileTextGroup;
    }

    private Control createIconDecoratorPage(Composite parent) {
        Composite imageGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        imageGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        imageGroup.setLayoutData((Object)data);
        this.createLabel(imageGroup, Policy.bind("CVSDecoratorPreferencesPage.iconDescription"), 1);
        this.imageShowDirty = this.createCheckBox(imageGroup, Policy.bind("Sho&w_outgoing_25"));
        this.imageShowHasRemote = this.createCheckBox(imageGroup, Policy.bind("Show_has_&remote_26"));
        this.imageShowAdded = this.createCheckBox(imageGroup, Policy.bind("S&how_is_added_27"));
        this.imageShowNewResource = this.createCheckBox(imageGroup, Policy.bind("CVSDecoratorPreferencesPage.newResources"));
        return imageGroup;
    }

    private Control createGeneralDecoratorPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createLabel(composite, Policy.bind("CVSDecoratorPreferencesPage.generalDescription"), 1);
        this.showDirty = this.createCheckBox(composite, Policy.bind("&Compute_deep_outgoing_state_for_folders_(disabling_this_will_improve_decorator_performance)_28"));
        return composite;
    }

    private Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 32);
        button.setText(label);
        return button;
    }

    protected void setTextFormatExample(Map bindings) {
        String example = CVSDecoratorConfiguration.bind(this.fileTextFormat.getText(), bindings);
        this.fileTextFormatExample.setText(example);
    }

    protected void setFolderFormatExample(Map bindings) {
        String example = CVSDecoratorConfiguration.bind(this.folderTextFormat.getText(), bindings);
        this.folderTextFormatExample.setText(example);
    }

    protected void setProjectFormatExample(Map bindings) {
        String example = CVSDecoratorConfiguration.bind(this.projectTextFormat.getText(), bindings);
        this.projectTextFormatExample.setText(example);
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fileTextFormat.setText(store.getString("pref_filetext_decoration"));
        this.folderTextFormat.setText(store.getString("pref_foldertext_decoration"));
        this.projectTextFormat.setText(store.getString("pref_projecttext_decoration"));
        this.addedFlag.setText(store.getString("pref_added_flag"));
        this.dirtyFlag.setText(store.getString("pref_dirty_flag"));
        this.imageShowDirty.setSelection(store.getBoolean("pref_show_overlaydirty"));
        this.imageShowAdded.setSelection(store.getBoolean("pref_show_added"));
        this.imageShowHasRemote.setSelection(store.getBoolean("pref_show_hasremote"));
        this.imageShowNewResource.setSelection(store.getBoolean("pref_show_newresource"));
        this.showDirty.setSelection(store.getBoolean("pref_calculate_dirty"));
        this.setValid(true);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_filetext_decoration", this.fileTextFormat.getText());
        store.setValue("pref_foldertext_decoration", this.folderTextFormat.getText());
        store.setValue("pref_projecttext_decoration", this.projectTextFormat.getText());
        store.setValue("pref_added_flag", this.addedFlag.getText());
        store.setValue("pref_dirty_flag", this.dirtyFlag.getText());
        store.setValue("pref_show_overlaydirty", this.imageShowDirty.getSelection());
        store.setValue("pref_show_added", this.imageShowAdded.getSelection());
        store.setValue("pref_show_hasremote", this.imageShowHasRemote.getSelection());
        store.setValue("pref_show_newresource", this.imageShowNewResource.getSelection());
        store.setValue("pref_calculate_dirty", this.showDirty.getSelection());
        CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        this.fileTextFormat.setText(store.getDefaultString("pref_filetext_decoration"));
        this.folderTextFormat.setText(store.getDefaultString("pref_foldertext_decoration"));
        this.projectTextFormat.setText(store.getDefaultString("pref_projecttext_decoration"));
        this.addedFlag.setText(store.getDefaultString("pref_added_flag"));
        this.dirtyFlag.setText(store.getDefaultString("pref_dirty_flag"));
        this.imageShowDirty.setSelection(store.getDefaultBoolean("pref_show_overlaydirty"));
        this.imageShowAdded.setSelection(store.getDefaultBoolean("pref_show_added"));
        this.imageShowHasRemote.setSelection(store.getDefaultBoolean("pref_show_hasremote"));
        this.imageShowNewResource.setSelection(store.getDefaultBoolean("pref_show_newresource"));
        this.showDirty.setSelection(store.getDefaultBoolean("pref_calculate_dirty"));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    private void addVariables(Text target, Map bindings) {
        final ArrayList<StringPair> variables = new ArrayList<StringPair>(bindings.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((StringPair)element).s1 + " - " + ((StringPair)element).s2;
            }
        };
        IStructuredContentProvider contentsProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return variables.toArray(new StringPair[variables.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        Iterator it = bindings.keySet().iterator();
        while (it.hasNext()) {
            StringPair variable = new StringPair();
            variable.s1 = (String)it.next();
            variable.s2 = (String)bindings.get(variable.s1);
            variables.add(variable);
        }
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)this, contentsProvider, (ILabelProvider)labelProvider, Policy.bind("Select_the_&variables_to_add_to_the_decoration_format__30"));
        dialog.setTitle(Policy.bind("Add_Variables_31"));
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        for (int i = 0; i < result.length; ++i) {
            target.insert("{" + ((StringPair)result[i]).s1 + "}");
        }
    }

    private Map getFolderBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("name", Policy.bind("name_of_the_resource_being_decorated_34"));
        bindings.put("tag", Policy.bind("the_tag_applied_to_the_resource_(version,_branch,_or_date)_35"));
        bindings.put("host", Policy.bind("the_repository_location__s_hostname_36"));
        bindings.put("method", Policy.bind("the_connection_method_(e.g._pserver,_ssh)_37"));
        bindings.put("user", Policy.bind("user_name_for_the_connection_38"));
        bindings.put("root", Policy.bind("repository_home_directory_on_server_39"));
        bindings.put("repository", Policy.bind("root_relative_directory_40"));
        bindings.put("dirty_flag", Policy.bind("flag_indicating_that_the_folder_has_a_child_resource_with_outgoing_changes_41"));
        return bindings;
    }

    private Map getFileBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("name", Policy.bind("name_of_the_resource_being_decorated_42"));
        bindings.put("tag", Policy.bind("the_tag_applied_to_the_resource_43"));
        bindings.put("keyword", Policy.bind("keyword_substitution_rule_for_the_resource_44"));
        bindings.put("revision", Policy.bind("last_revision_loaded_into_workspace_45"));
        bindings.put("dirty_flag", Policy.bind("flag_indicating_that_the_file_has_outgoing_changes_46"));
        bindings.put("added_flag", Policy.bind("flag_indicating_that_the_file_has_been_added_to_the_server_47"));
        return bindings;
    }

    class TextPair {
        Text t1;
        Text t2;

        TextPair(Text t1, Text t2) {
            this.t1 = t1;
            this.t2 = t2;
        }
    }

    class StringPair {
        String s1;
        String s2;

        StringPair() {
        }
    }
}

