/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.ui.launchConfigurations.AntBuildTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntJavaLaunchDelegate;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.ui.launchConfigurations.RemoteAntBuildListener;
import org.eclipse.ant.internal.ui.launchConfigurations.TaskLinkManager;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.BackgroundResourceRefresher;

public class AntLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final String ANT_LOGGER_CLASS = "org.eclipse.ant.internal.ui.antsupport.logger.AntProcessBuildLogger";
    private static final String NULL_LOGGER_CLASS = "org.eclipse.ant.internal.ui.antsupport.logger.NullBuildLogger";
    private static final String REMOTE_ANT_LOGGER_CLASS = "org.eclipse.ant.internal.ui.antsupport.logger.RemoteAntBuildLogger";
    private static final String BASE_DIR_PREFIX = "-Dbasedir=";
    private static final String INPUT_HANDLER_CLASS = "org.eclipse.ant.internal.ui.antsupport.inputhandler.AntInputHandler";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        AntUtil.migrateToNewClasspathFormat(configuration);
        String vmTypeID = null;
        try {
            vmTypeID = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, (String)null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(ce);
        }
        if (CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Launching_{0}_1"), configuration.getName()), 10);
        } else {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Running_{0}_2"), configuration.getName()), 100);
        }
        IPath location = ExternalToolsUtil.getLocation((ILaunchConfiguration)configuration);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        if (vmTypeID == null && AntRunner.isBuildRunning()) {
            Status status = new Status(4, "org.eclipse.ant.ui", 1, MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Build_In_Progress"), location.toOSString()), null);
            throw new CoreException((IStatus)status);
        }
        IPath workingDirectory = ExternalToolsUtil.getWorkingDirectory((ILaunchConfiguration)configuration);
        String basedir = null;
        if (workingDirectory != null) {
            basedir = workingDirectory.toOSString();
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        String idStamp = Long.toString(timeStamp);
        StringBuffer idProperty = new StringBuffer("-D");
        idProperty.append("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID");
        idProperty.append('=');
        idProperty.append(idStamp);
        String[] arguments = ExternalToolsUtil.getArguments((ILaunchConfiguration)configuration);
        HashMap<String, String> userProperties = AntUtil.getProperties(configuration);
        String[] propertyFiles = AntUtil.getPropertyFiles(configuration);
        String[] targets = AntUtil.getTargetsFromConfig(configuration);
        URL[] customClasspath = AntUtil.getCustomClasspath(configuration);
        String antHome = AntUtil.getAntHome(configuration);
        AntRunner runner = null;
        if (vmTypeID == null) {
            runner = this.configureAntRunner(configuration, location, basedir, idProperty, arguments, userProperties, propertyFiles, targets, customClasspath, antHome);
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        boolean captureOutput = ExternalToolsUtil.getCaptureOutput((ILaunchConfiguration)configuration);
        int port = -1;
        if (vmTypeID != null && captureOutput) {
            if (userProperties == null) {
                userProperties = new HashMap<String, String>();
            }
            port = SocketUtil.findFreePort();
            userProperties.put("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID", idStamp);
            userProperties.put("eclipse.connect.port", Integer.toString(port));
        }
        StringBuffer commandLine = this.generateCommandLine(location, arguments, userProperties, propertyFiles, targets, antHome, basedir, vmTypeID != null, captureOutput);
        if (vmTypeID != null) {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Launching_{0}_1"), configuration.getName()), 10);
            this.runInSeparateVM(configuration, launch, monitor, idStamp, port, commandLine, captureOutput);
        } else {
            this.runInSameVM(configuration, launch, monitor, location, idStamp, runner, commandLine);
        }
        monitor.done();
    }

    private void runInSameVM(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor, IPath location, String idStamp, AntRunner runner, StringBuffer commandLine) throws CoreException {
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        attributes.put(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.ant.ui.antProcess");
        attributes.put("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID", idStamp);
        final AntProcess process = new AntProcess(location.toOSString(), launch, attributes);
        this.setProcessAttributes(process, idStamp, commandLine);
        if (CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
            final AntRunner finalRunner = runner;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        finalRunner.run((IProgressMonitor)process);
                    }
                    catch (CoreException e) {
                        AntLaunchDelegate.this.handleException(e, AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Failure"));
                    }
                    process.terminated();
                }
            };
            Thread background = new Thread(r);
            background.start();
            monitor.worked(1);
            if (RefreshTab.getRefreshScope((ILaunchConfiguration)configuration) != null) {
                BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, (IProcess)process);
                refresher.startBackgroundRefresh();
            }
        } else {
            try {
                runner.run(monitor);
            }
            catch (CoreException e) {
                process.terminated();
                monitor.done();
                this.handleException(e, AntLaunchConfigurationMessages.getString("AntLaunchDelegate.23"));
                return;
            }
            process.terminated();
            RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
    }

    private AntRunner configureAntRunner(ILaunchConfiguration configuration, IPath location, String baseDir, StringBuffer idProperty, String[] arguments, Map userProperties, String[] propertyFiles, String[] targets, URL[] customClasspath, String antHome) throws CoreException {
        int argLength = 1;
        if (arguments != null) {
            argLength += arguments.length;
        }
        if (baseDir != null && baseDir.length() > 0) {
            ++argLength;
        }
        String[] runnerArgs = new String[argLength];
        if (arguments != null) {
            System.arraycopy(arguments, 0, runnerArgs, 0, arguments.length);
        }
        if (baseDir != null && baseDir.length() > 0) {
            runnerArgs[runnerArgs.length - 2] = BASE_DIR_PREFIX + baseDir;
        }
        runnerArgs[runnerArgs.length - 1] = idProperty.toString();
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(location.toOSString());
        if (ExternalToolsUtil.getCaptureOutput((ILaunchConfiguration)configuration)) {
            runner.addBuildLogger(ANT_LOGGER_CLASS);
        } else {
            runner.addBuildLogger(NULL_LOGGER_CLASS);
        }
        runner.setInputHandler(INPUT_HANDLER_CLASS);
        runner.setArguments(runnerArgs);
        if (userProperties != null) {
            runner.addUserProperties(userProperties);
        }
        if (propertyFiles != null) {
            runner.setPropertyFiles(propertyFiles);
        }
        if (targets != null) {
            runner.setExecutionTargets(targets);
        }
        if (customClasspath != null) {
            runner.setCustomClasspath(customClasspath);
        }
        if (antHome != null) {
            runner.setAntHome(antHome);
        }
        return runner;
    }

    private void handleException(final CoreException e, final String title) {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("errorDialog")) {
            AntUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialogWithToggle.openError(null, (String)title, (String)e.getMessage(), (String)AntLaunchConfigurationMessages.getString("AntLaunchDelegate.22"), (boolean)false, (IPreferenceStore)AntUIPlugin.getDefault().getPreferenceStore(), (String)"errorDialog");
                }
            });
        }
    }

    private void setProcessAttributes(IProcess process, String idStamp, StringBuffer commandLine) {
        process.setAttribute("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID", idStamp);
        if (commandLine != null) {
            process.setAttribute(IProcess.ATTR_CMDLINE, commandLine.toString());
        }
        TaskLinkManager.registerAntBuild(process);
    }

    private StringBuffer generateCommandLine(IPath location, String[] arguments, Map userProperties, String[] propertyFiles, String[] targets, String antHome, String basedir, boolean separateVM, boolean captureOutput) {
        boolean useGlobalProperties;
        StringBuffer commandLine = new StringBuffer();
        if (!separateVM) {
            commandLine.append("ant");
        }
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                String arg = arguments[i];
                commandLine.append(' ');
                commandLine.append(arg);
            }
        }
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        if (propertyFiles == null) {
            String[] files = prefs.getCustomPropertyFiles();
            for (int i = 0; i < files.length; ++i) {
                String path = files[i];
                commandLine.append(" -propertyfile \"");
                commandLine.append(path);
                commandLine.append('\"');
            }
        } else {
            for (int i = 0; i < propertyFiles.length; ++i) {
                String path = propertyFiles[i];
                commandLine.append(" -propertyfile \"");
                commandLine.append(path);
                commandLine.append('\"');
            }
        }
        if (userProperties != null) {
            Iterator keys = userProperties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.appendProperty(commandLine, key, (String)userProperties.get(key));
            }
        }
        List properties = null;
        properties = !separateVM ? prefs.getProperties() : prefs.getRemoteAntProperties();
        boolean bl = useGlobalProperties = userProperties == null || separateVM && userProperties.size() == 2;
        if (useGlobalProperties) {
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                String key = property.getName();
                String value = property.getValue();
                if (value == null) continue;
                this.appendProperty(commandLine, key, value);
            }
        }
        if (basedir != null && basedir.length() > 0) {
            this.appendProperty(commandLine, "basedir", basedir);
        }
        if (antHome != null) {
            commandLine.append(" \"-Dant.home=");
            commandLine.append(antHome);
            commandLine.append('\"');
        }
        if (separateVM) {
            if (commandLine.indexOf("-logger") == -1 && captureOutput) {
                commandLine.append(" -logger ");
                commandLine.append(REMOTE_ANT_LOGGER_CLASS);
            }
        } else {
            commandLine.append(" -inputhandler ");
            commandLine.append(INPUT_HANDLER_CLASS);
            commandLine.append(" -logger ");
            if (captureOutput) {
                commandLine.append(ANT_LOGGER_CLASS);
            } else {
                commandLine.append(NULL_LOGGER_CLASS);
            }
        }
        if (separateVM) {
            this.appendTaskAndTypes(prefs, commandLine);
        }
        commandLine.append(" -buildfile \"");
        commandLine.append(location.toOSString());
        commandLine.append('\"');
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                commandLine.append(" \"");
                commandLine.append(targets[i]);
                commandLine.append('\"');
            }
        }
        return commandLine;
    }

    private void appendTaskAndTypes(AntCorePreferences prefs, StringBuffer commandLine) {
        List tasks = prefs.getRemoteTasks();
        Iterator itr = tasks.iterator();
        while (itr.hasNext()) {
            Task task = (Task)itr.next();
            commandLine.append(" -eclipseTask ");
            commandLine.append(task.getTaskName());
            commandLine.append(',');
            commandLine.append(task.getClassName());
        }
        List types = prefs.getRemoteTypes();
        itr = types.iterator();
        while (itr.hasNext()) {
            Type type = (Type)itr.next();
            commandLine.append(" -eclipseType ");
            commandLine.append(type.getTypeName());
            commandLine.append(',');
            commandLine.append(type.getClassName());
        }
    }

    private void appendProperty(StringBuffer commandLine, String name, String value) {
        commandLine.append(" \"-D");
        commandLine.append(name);
        commandLine.append('=');
        commandLine.append(value);
        commandLine.append(" \"");
    }

    private void runInSeparateVM(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor, String idStamp, int port, StringBuffer commandLine, boolean captureOutput) throws CoreException {
        if (captureOutput) {
            RemoteAntBuildListener client = new RemoteAntBuildListener(launch);
            if (port != -1) {
                client.startListening(port);
            }
        }
        ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, commandLine.toString());
        StringBuffer vmArgs = this.generateVMArguments((ILaunchConfiguration)copy);
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs.toString());
        launch.setSourceLocator(new ISourceLocator(){

            public Object getSourceElement(IStackFrame stackFrame) {
                return null;
            }
        });
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        AntJavaLaunchDelegate delegate = new AntJavaLaunchDelegate();
        delegate.preLaunchCheck((ILaunchConfiguration)copy, "run", (IProgressMonitor)subMonitor);
        delegate.launch((ILaunchConfiguration)copy, "run", launch, (IProgressMonitor)subMonitor);
        final IProcess[] processes = launch.getProcesses();
        for (int i = 0; i < processes.length; ++i) {
            this.setProcessAttributes(processes[i], idStamp, null);
        }
        if (CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
            if (RefreshTab.getRefreshScope((ILaunchConfiguration)configuration) != null) {
                BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, processes[0]);
                refresher.startBackgroundRefresh();
            }
        } else {
            final boolean[] terminated = new boolean[]{launch.isTerminated()};
            IDebugEventSetListener listener = new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    block0: for (int i = 0; i < events.length; ++i) {
                        DebugEvent event = events[i];
                        int numProcesses = processes.length;
                        for (int j = 0; j < numProcesses; ++j) {
                            if (event.getSource() != processes[j] || event.getKind() != 8) continue;
                            terminated[0] = true;
                            continue block0;
                        }
                    }
                }
            };
            DebugPlugin.getDefault().addDebugEventListener(listener);
            monitor.subTask(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.28"));
            while (!monitor.isCanceled() && !terminated[0]) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {}
            }
            DebugPlugin.getDefault().removeDebugEventListener(listener);
            if (!monitor.isCanceled()) {
                RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
            }
        }
    }

    private StringBuffer generateVMArguments(ILaunchConfiguration config) {
        StringBuffer vmArgs = new StringBuffer();
        try {
            String configArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, (String)null);
            if (configArgs != null) {
                vmArgs.append(configArgs);
                vmArgs.append(' ');
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
        vmArgs.append("-Dant.home=\"");
        vmArgs.append(AntCorePlugin.getPlugin().getPreferences().getAntHome());
        vmArgs.append("\" ");
        File antLibDir = new File(AntCorePlugin.getPlugin().getPreferences().getAntHome(), "lib");
        vmArgs.append("-Dant.library.dir=\"");
        vmArgs.append(antLibDir.getAbsolutePath());
        vmArgs.append('\"');
        return vmArgs;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        String scope = null;
        try {
            scope = configuration.getAttribute(AntBuildTab.ATTR_BUILD_SCOPE, (String)null);
        }
        catch (CoreException e) {
            return null;
        }
        if (scope == null) {
            return null;
        }
        IProject[] projects = AntBuildTab.getBuildProjects(scope);
        boolean isRef = AntBuildTab.isIncludeReferencedProjects(configuration);
        if (isRef) {
            return this.computeReferencedBuildOrder(projects);
        }
        return this.computeBuildOrder(projects);
    }
}

