/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeCompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferFactoryWrapper;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;

public class ClassFile
extends Openable
implements IClassFile,
SuffixConstants {
    protected BinaryType binaryType = null;
    private boolean checkAutomaticSourceMapping = false;

    protected ClassFile(PackageFragment parent, String name) {
        super(parent, name);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (!this.isValidClassFile()) {
            throw this.newNotPresentException();
        }
        if (underlyingResource != null && !underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        IBinaryType typeInfo = this.getBinaryTypeInfo((IFile)underlyingResource);
        if (typeInfo == null) {
            info.setChildren(new IJavaElement[0]);
            return false;
        }
        BinaryType type = new BinaryType(this, new String(ClassFile.simpleName(typeInfo.getName())));
        info.addChild(type);
        newElements.put(type, typeInfo);
        return true;
    }

    public void codeComplete(int offset, ICompletionRequestor requestor) throws JavaModelException {
        this.codeComplete(offset, requestor, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(int offset, ICompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        String source = this.getSource();
        if (source != null) {
            String elementName = this.getElementName();
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), (char[][])null, elementName.substring(0, elementName.length() - ".class".length()) + ".java", this.getJavaProject());
            this.codeComplete(cu, cu, offset, requestor, owner);
        }
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws JavaModelException {
        throw new RuntimeException("Not implemented yet");
    }

    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner wcowner) throws JavaModelException {
        throw new RuntimeException("Not implemented yet");
    }

    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IJavaElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            String topLevelTypeName = this.getTopLevelTypeName();
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, null, topLevelTypeName + ".java");
            return super.codeSelect(cu, offset, length, owner);
        }
        return new IJavaElement[0];
    }

    protected Object createElementInfo() {
        return new ClassFileInfo(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassFile)) {
            return false;
        }
        return super.equals(o);
    }

    public boolean exists() {
        return super.exists() && this.isValidClassFile();
    }

    protected IJavaElement findElement(IJavaElement elt, int position, SourceMapper mapper) {
        SourceRange range = mapper.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaElement[] children = ((IParent)((Object)elt)).getChildren();
                for (int i = 0; i < children.length; ++i) {
                    IJavaElement match = this.findElement(children[i], position, mapper);
                    if (match == null) continue;
                    return match;
                }
            }
            catch (JavaModelException npe) {
                // empty catch block
            }
        }
        return elt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinaryType getBinaryTypeInfo(IFile file) throws JavaModelException {
        JavaElement le = (JavaElement)this.getParent();
        if (le instanceof JarPackageFragment) {
            try {
                JarPackageFragmentRoot root = (JarPackageFragmentRoot)le.getParent();
                ClassFileReader info = null;
                ZipFile zip = null;
                try {
                    zip = root.getJar();
                    String entryName = this.getParent().getElementName();
                    entryName = entryName.replace('.', '/');
                    entryName = entryName.equals("") ? entryName + this.getElementName() : entryName + '/' + this.getElementName();
                    info = ClassFileReader.read(zip, entryName, true);
                }
                finally {
                    JavaModelManager.getJavaModelManager().closeZipFile(zip);
                }
                if (info == null) {
                    throw this.newNotPresentException();
                }
                return info;
            }
            catch (ClassFormatException cfe) {
                if (JavaCore.getPlugin().isDebugging()) {
                    cfe.printStackTrace(System.err);
                }
                return null;
            }
            catch (IOException ioe) {
                throw new JavaModelException(ioe, 985);
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        byte[] contents = Util.getResourceContentsAsByteArray(file);
        try {
            return new ClassFileReader(contents, this.getElementName().toCharArray());
        }
        catch (ClassFormatException cfe) {
            return null;
        }
    }

    public IBuffer getBuffer() throws JavaModelException {
        if (this.isValidClassFile()) {
            return super.getBuffer();
        }
        return this.openBuffer(null, null);
    }

    public IClassFile getClassFile() {
        return this;
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        IType type = this.getType();
        return this.findElement(type, position, mapper);
    }

    public int getElementType() {
        return 6;
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '[': {
                String typeName = memento.nextToken();
                BinaryType type = new BinaryType(this, typeName);
                return type.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '(';
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    public String getTopLevelTypeName() {
        String topLevelTypeName = this.getElementName();
        int firstDollar = topLevelTypeName.indexOf(36);
        topLevelTypeName = firstDollar != -1 ? topLevelTypeName.substring(0, firstDollar) : topLevelTypeName.substring(0, topLevelTypeName.length() - SuffixConstants.SUFFIX_CLASS.length);
        return topLevelTypeName;
    }

    public IType getType() {
        if (this.binaryType == null) {
            String typeName = this.name.substring(0, this.name.lastIndexOf(46));
            int index = (typeName = typeName.substring(typeName.lastIndexOf(46) + 1)).lastIndexOf(36);
            if (index > -1 && typeName.length() > index + 1 && !Character.isDigit(typeName.charAt(index + 1))) {
                typeName = typeName.substring(index + 1);
            }
            this.binaryType = new BinaryType(this, typeName);
        }
        return this.binaryType;
    }

    public ICompilationUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        char[] contents = null;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            contents = mapper.findSource(this.getType());
        }
        if (contents == null) {
            return null;
        }
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy();
        workingCopy.buffer = buffer = owner == null ? this.getBuffer() : owner.createBuffer(workingCopy);
        if (buffer != null && buffer.getCharacters() == null) {
            buffer.setContents(contents);
        }
        return workingCopy;
    }

    public IJavaElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws JavaModelException {
        return this.getWorkingCopy(BufferFactoryWrapper.create(factory), monitor);
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean isClass() throws JavaModelException {
        return this.getType().isClass();
    }

    public boolean isInterface() throws JavaModelException {
        return this.getType().isInterface();
    }

    public boolean isReadOnly() {
        return true;
    }

    private boolean isValidClassFile() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 2) {
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return Util.isValidClassFileName(this.getElementName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return this.mapSource(mapper);
        }
        if (this.checkAutomaticSourceMapping) return null;
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            String elementName = this.getElementName();
            StringBuffer sourceFileName = new StringBuffer(elementName.substring(0, elementName.lastIndexOf(46)));
            sourceFileName.append(SuffixConstants.SUFFIX_java);
            JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)root;
            ZipFile jar = null;
            try {
                jar = jarPackageFragmentRoot.getJar();
                IPackageFragment packageFragment = (IPackageFragment)this.getParent();
                ZipEntry zipEntry = null;
                zipEntry = packageFragment.isDefaultPackage() ? jar.getEntry(sourceFileName.toString()) : jar.getEntry(this.getParent().getElementName() + '/' + sourceFileName.toString());
                if (zipEntry == null) return null;
                this.checkAutomaticSourceMapping = true;
                root.attachSource(root.getPath(), null, null);
                SourceMapper sourceMapper = this.getSourceMapper();
                if (sourceMapper == null) return null;
                IBuffer iBuffer = this.mapSource(sourceMapper);
                return iBuffer;
            }
            catch (CoreException e) {
                if (!(e instanceof JavaModelException)) throw new JavaModelException(e);
                throw (JavaModelException)e;
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
            }
        } else {
            String qualifiedName = this.getType().getFullyQualifiedName();
            NameLookup lookup = ((JavaProject)this.getJavaProject()).newNameLookup(DefaultWorkingCopyOwner.PRIMARY);
            ICompilationUnit cu = lookup.findCompilationUnit(qualifiedName);
            if (cu != null) {
                return cu.getBuffer();
            }
            IPath sourceFilePath = this.getPath().removeFileExtension().addFileExtension("java");
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace == null) {
                this.checkAutomaticSourceMapping = true;
                return null;
            }
            if (JavaModel.getTarget((IContainer)workspace.getRoot(), sourceFilePath.makeRelative(), true) == null) return null;
            this.checkAutomaticSourceMapping = true;
            root.attachSource(root.getPath(), null, null);
            SourceMapper sourceMapper = this.getSourceMapper();
            if (sourceMapper == null) return null;
            return this.mapSource(sourceMapper);
        }
    }

    private IBuffer mapSource(SourceMapper mapper) {
        char[] contents = mapper.findSource(this.getType());
        if (contents != null) {
            IBuffer buffer = this.getBufferManager().createBuffer(this);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            mapper.mapSource(this.getType(), contents);
            return buffer;
        }
        return null;
    }

    static char[] simpleName(char[] className) {
        int lastPosition;
        if (className == null) {
            return null;
        }
        className = ClassFile.unqualifiedName(className);
        int count = 0;
        for (int i = lastPosition = className.length - 1; i > -1; --i) {
            if (className[i] == '$' && i != lastPosition) {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                if (Character.isDigit(name[0])) break;
                return name;
            }
            ++count;
        }
        return className;
    }

    public static char[] translatedName(char[] name) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length;
        char[] newName = new char[nameLength];
        for (int i = 0; i < nameLength; ++i) {
            newName[i] = name[i] == '/' ? 46 : name[i];
        }
        return newName;
    }

    static char[][] translatedNames(char[][] names) {
        if (names == null) {
            return null;
        }
        int length = names.length;
        char[][] newNames = new char[length][];
        for (int i = 0; i < length; ++i) {
            newNames[i] = ClassFile.translatedName(names[i]);
        }
        return newNames;
    }

    static char[] unqualifiedName(char[] className) {
        if (className == null) {
            return null;
        }
        int count = 0;
        for (int i = className.length - 1; i > -1; --i) {
            if (className[i] == '/') {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                return name;
            }
            ++count;
        }
        return className;
    }

    public void codeComplete(int offset, final ICodeCompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            this.codeComplete(offset, (ICompletionRequestor)null);
            return;
        }
        this.codeComplete(offset, new ICompletionRequestor(){

            public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptClass(packageName, className, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptError(IProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] fieldName, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptField(declaringTypePackageName, declaringTypeName, fieldName, typePackageName, typeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptKeyword(keywordName, completionStart, completionEnd);
            }

            public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptLabel(labelName, completionStart, completionEnd);
            }

            public void acceptLocalVariable(char[] localVarName, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptModifier(modifierName, completionStart, completionEnd);
            }

            public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptPackage(packageName, completionName, completionStart, completionEnd);
            }

            public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptType(packageName, typeName, completionName, completionStart, completionEnd);
            }

            public void acceptVariableName(char[] typePackageName, char[] typeName, char[] varName, char[] completionName, int completionStart, int completionEnd, int relevance) {
            }
        });
    }
}

