/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public class OrPattern
extends SearchPattern
implements IIndexConstants {
    protected SearchPattern[] patterns;

    public OrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(Math.max(leftPattern.getMatchRule(), rightPattern.getMatchRule()));
        this.kind = 256;
        this.mustResolve = leftPattern.mustResolve || rightPattern.mustResolve;
        SearchPattern[] leftPatterns = leftPattern instanceof OrPattern ? ((OrPattern)leftPattern).patterns : null;
        SearchPattern[] rightPatterns = rightPattern instanceof OrPattern ? ((OrPattern)rightPattern).patterns : null;
        int leftSize = leftPatterns == null ? 1 : leftPatterns.length;
        int rightSize = rightPatterns == null ? 1 : rightPatterns.length;
        this.patterns = new SearchPattern[leftSize + rightSize];
        if (leftPatterns == null) {
            this.patterns[0] = leftPattern;
        } else {
            System.arraycopy(leftPatterns, 0, this.patterns, 0, leftSize);
        }
        if (rightPatterns == null) {
            this.patterns[leftSize] = rightPattern;
        } else {
            System.arraycopy(rightPatterns, 0, this.patterns, leftSize, rightSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        try {
            index.startQuery();
            int length = this.patterns.length;
            for (int i = 0; i < length; ++i) {
                this.patterns[i].findIndexMatches(index, requestor, participant, scope, progressMonitor);
            }
        }
        finally {
            index.stopQuery();
        }
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    boolean isPolymorphicSearch() {
        int length = this.patterns.length;
        for (int i = 0; i < length; ++i) {
            if (!this.patterns[i].isPolymorphicSearch()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.patterns[0].toString());
        int length = this.patterns.length;
        for (int i = 1; i < length; ++i) {
            buffer.append("\n| ");
            buffer.append(this.patterns[i].toString());
        }
        return buffer.toString();
    }
}

