/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.CommentRecorderScanner;

public class CommentRecorderParser
extends Parser {
    int[] commentStops = new int[10];
    int[] commentStarts = new int[10];
    int commentPtr = -1;
    protected static final int CommentIncrement = 100;

    public CommentRecorderParser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    public void checkComment() {
        if (this.currentElement != null && this.scanner.commentPtr >= 0) {
            this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        }
        boolean deprecated = false;
        boolean checkDeprecated = false;
        int lastCommentIndex = -1;
        for (lastCommentIndex = this.scanner.commentPtr; lastCommentIndex >= 0; --lastCommentIndex) {
            int commentSourceStart = this.scanner.commentStarts[lastCommentIndex];
            if (commentSourceStart < 0 || this.modifiersSourceStart != -1 && this.modifiersSourceStart < commentSourceStart || this.scanner.commentStops[lastCommentIndex] < 0) continue;
            checkDeprecated = true;
            int commentSourceEnd = this.scanner.commentStops[lastCommentIndex] - 1;
            deprecated = this.javadocParser.checkDeprecation(commentSourceStart, commentSourceEnd);
            this.javadoc = this.javadocParser.docComment;
            break;
        }
        if (deprecated) {
            this.checkAndSetModifiers(0x100000);
        }
        if (lastCommentIndex >= 0 && checkDeprecated) {
            this.modifiersSourceStart = this.scanner.commentStarts[lastCommentIndex];
            if (this.modifiersSourceStart < 0) {
                this.modifiersSourceStart = -this.modifiersSourceStart;
            }
        }
    }

    protected void consumeClassHeader() {
        this.pushOnCommentsStack(0, this.scanner.commentPtr);
        super.consumeClassHeader();
    }

    protected void consumeEmptyClassMemberDeclaration() {
        this.pushOnCommentsStack(0, this.scanner.commentPtr);
        super.consumeEmptyClassMemberDeclaration();
    }

    protected void consumeEmptyTypeDeclaration() {
        this.pushOnCommentsStack(0, this.scanner.commentPtr);
        super.consumeEmptyTypeDeclaration();
    }

    protected void consumeInterfaceHeader() {
        this.pushOnCommentsStack(0, this.scanner.commentPtr);
        super.consumeInterfaceHeader();
    }

    public boolean containsComment(int sourceStart, int sourceEnd) {
        for (int iComment = this.scanner.commentPtr; iComment >= 0; --iComment) {
            int commentStart = this.scanner.commentStarts[iComment];
            if (commentStart < 0) {
                commentStart = -commentStart;
            }
            if (commentStart < sourceStart || commentStart > sourceEnd) continue;
            return true;
        }
        return false;
    }

    protected CompilationUnitDeclaration endParse(int act) {
        CompilationUnitDeclaration unit = super.endParse(act);
        if (unit.comments == null) {
            this.pushOnCommentsStack(0, this.scanner.commentPtr);
            unit.comments = this.getCommentsPositions();
        }
        return unit;
    }

    public int flushCommentsDefinedPriorTo(int position) {
        int lastCommentIndex = this.scanner.commentPtr;
        if (lastCommentIndex < 0) {
            return position;
        }
        int index = lastCommentIndex;
        int validCount = 0;
        while (index >= 0) {
            int commentEnd = this.scanner.commentStops[index];
            if (commentEnd < 0) {
                commentEnd = -commentEnd;
            }
            if (commentEnd <= position) break;
            --index;
            ++validCount;
        }
        if (validCount > 0) {
            int immediateCommentEnd = 0;
            while (index < lastCommentIndex && (immediateCommentEnd = -this.scanner.commentStops[index + 1]) > 0 && this.scanner.getLineNumber(position) == this.scanner.getLineNumber(--immediateCommentEnd)) {
                position = immediateCommentEnd;
                --validCount;
                ++index;
            }
        }
        if (index < 0) {
            return position;
        }
        this.pushOnCommentsStack(0, index);
        if (validCount > 0) {
            System.arraycopy(this.scanner.commentStarts, index + 1, this.scanner.commentStarts, 0, validCount);
            System.arraycopy(this.scanner.commentStops, index + 1, this.scanner.commentStops, 0, validCount);
        }
        this.scanner.commentPtr = validCount - 1;
        return position;
    }

    public int[][] getCommentsPositions() {
        int[][] positions = new int[this.commentPtr + 1][2];
        int max = this.commentPtr;
        for (int i = 0; i <= max; ++i) {
            positions[i][0] = this.commentStarts[i];
            positions[i][1] = this.commentStops[i];
        }
        return positions;
    }

    public void initialize() {
        super.initialize();
        this.commentPtr = -1;
    }

    public void initializeScanner() {
        this.scanner = new CommentRecorderScanner(false, false, this.options.getSeverity(256L) != -1, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorites, this.options.isTaskCaseSensitive);
    }

    private void pushOnCommentsStack(int start, int end) {
        for (int i = start; i <= end; ++i) {
            int commentStart;
            int scannerStart;
            int n = scannerStart = this.scanner.commentStarts[i] < 0 ? -this.scanner.commentStarts[i] : this.scanner.commentStarts[i];
            int n2 = this.commentPtr == -1 ? -1 : (commentStart = this.commentStarts[this.commentPtr] < 0 ? -this.commentStarts[this.commentPtr] : this.commentStarts[this.commentPtr]);
            if (commentStart != -1 && scannerStart <= commentStart) continue;
            int stackLength = this.commentStarts.length;
            if (++this.commentPtr >= stackLength) {
                this.commentStarts = new int[stackLength + 100];
                System.arraycopy(this.commentStarts, 0, this.commentStarts, 0, stackLength);
                this.commentStops = new int[stackLength + 100];
                System.arraycopy(this.commentStops, 0, this.commentStops, 0, stackLength);
            }
            this.commentStarts[this.commentPtr] = this.scanner.commentStarts[i];
            this.commentStops[this.commentPtr] = this.scanner.commentStops[i];
        }
    }

    protected void resetModifiers() {
        this.pushOnCommentsStack(0, this.scanner.commentPtr);
        super.resetModifiers();
    }
}

