/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.media.IncompatibleSourceException;
import javax.media.MediaHandler;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.PackageManager;
import javax.media.Player;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.URLDataSource;
import org.videolan.Logger;

public final class Manager {
    public static final String UNKNOWN_CONTENT_NAME = "unknown";
    private static final TimeBase systemTimeBase = new SystemTimeBase();
    private static final Logger logger = Logger.getLogger(Manager.class.getName());
    static /* synthetic */ Class class$javax$media$Player;
    static /* synthetic */ Class class$javax$media$MediaProxy;

    public static Player createPlayer(URL sourceURL) throws IOException, NoPlayerException {
        return Manager.createPlayer(new MediaLocator(sourceURL));
    }

    public static Player createPlayer(MediaLocator sourceLocator) throws IOException, NoPlayerException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        Vector dataSourceList = Manager.getDataSourceList(protocol);
        for (int i = 0; i < dataSourceList.size(); ++i) {
            String dataSourceClassName = (String)dataSourceList.get(i);
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return Manager.createPlayer(dataSource);
            }
            catch (NoPlayerException e) {
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.warning("createPlayer: " + e);
                continue;
            }
            catch (IOException e) {
                logger.warning("" + e);
                continue;
            }
            catch (NoClassDefFoundError e) {
                logger.warning("" + e);
                continue;
            }
            catch (Exception e) {
                logger.warning("" + e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.warning("" + e);
            throw new NoPlayerException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return Manager.createPlayer(dataSource);
    }

    public static Player createPlayer(DataSource source) throws IOException, NoPlayerException {
        return Manager.createPlayer(source, source.getContentType());
    }

    public static DataSource createDataSource(URL sourceURL) throws IOException, NoDataSourceException {
        return Manager.createDataSource(new MediaLocator(sourceURL));
    }

    public static DataSource createDataSource(MediaLocator sourceLocator) throws IOException, NoDataSourceException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        Vector dataSourceList = Manager.getDataSourceList(protocol);
        for (int i = 0; i < dataSourceList.size(); ++i) {
            String dataSourceClassName = (String)dataSourceList.get(i);
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return dataSource;
            }
            catch (ClassNotFoundException e) {
                logger.warning("createDataSource: " + e);
                continue;
            }
            catch (IOException e) {
                logger.warning("" + e);
                continue;
            }
            catch (NoClassDefFoundError e) {
                logger.warning("" + e);
                continue;
            }
            catch (Exception e) {
                logger.warning("" + e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.warning("" + e);
            throw new NoDataSourceException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return dataSource;
    }

    public static TimeBase getSystemTimeBase() {
        return systemTimeBase;
    }

    public static Vector getDataSourceList(String protocolName) {
        return Manager.getClassList(protocolName, PackageManager.getProtocolPrefixList(), "protocol", "DataSource");
    }

    public static Vector getHandlerClassList(String contentName) {
        return Manager.getClassList(Manager.toPackageFriendly(contentName), PackageManager.getContentPrefixList(), "content", "Handler");
    }

    private static Player createPlayer(DataSource source, String contentType) throws IOException, NoPlayerException {
        Vector handlerClassList = Manager.getHandlerClassList(contentType);
        for (int i = 0; i < handlerClassList.size(); ++i) {
            String handlerClassName = (String)handlerClassList.get(i);
            try {
                System.out.println(handlerClassName);
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!(class$javax$media$Player == null ? Manager.class$("javax.media.Player") : class$javax$media$Player).isAssignableFrom(handlerClass) && !(class$javax$media$MediaProxy == null ? Manager.class$("javax.media.MediaProxy") : class$javax$media$MediaProxy).isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(source);
                if (handler instanceof Player) {
                    return (Player)handler;
                }
                if (!(handler instanceof MediaProxy)) continue;
                MediaProxy mediaProxy = (MediaProxy)handler;
                return Manager.createPlayer(mediaProxy.getDataSource());
            }
            catch (ClassNotFoundException e) {
                logger.warning("createPlayer: " + e);
                continue;
            }
            catch (IncompatibleSourceException e) {
                logger.warning("createPlayer(" + source + ", " + contentType + "): " + e);
                continue;
            }
            catch (IOException e) {
                logger.warning("" + e);
                continue;
            }
            catch (NoPlayerException e) {
                continue;
            }
            catch (NoClassDefFoundError e) {
                logger.warning("" + e);
                continue;
            }
            catch (Exception e) {
                logger.warning("" + e);
            }
        }
        logger.error("No player found for " + contentType + " / " + source.getLocator());
        throw new NoPlayerException("No player found for " + source.getLocator());
    }

    private static char toPackageFriendly(char c) {
        if (c >= 'a' && c <= 'z') {
            return c;
        }
        if (c >= 'A' && c <= 'Z') {
            return c;
        }
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c == '.') {
            return c;
        }
        if (c == '/') {
            return '.';
        }
        return '_';
    }

    private static String toPackageFriendly(String contentName) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < contentName.length(); ++i) {
            char c = contentName.charAt(i);
            b.append(Manager.toPackageFriendly(c));
        }
        return b.toString();
    }

    public static Vector getClassList(String contentName, Vector packages, String component2, String className) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < packages.size(); ++i) {
            result.add((String)packages.get(i) + ".media." + component2 + "." + contentName + "." + className);
        }
        return result;
    }
}

