/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common.medias;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlMedia;
import org.videolan.vlma.common.medias.VlMediaGroup;
import org.videolan.vlma.common.programs.IVlProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlFilesChannel
extends VlMedia {
    public static final String SAP_GROUP = "Files";
    private static final Logger logger = Logger.getLogger(VlFilesChannel.class);
    private String fullname;
    private List<String> files = new ArrayList<String>();
    private VlServer server;

    @Override
    public void setProgram(IVlProgram program) {
        super.setProgram(program);
        this.updateSapGroup();
    }

    protected void updateSapGroup() {
        if (this.program != null) {
            this.program.setSapGroup(SAP_GROUP);
        }
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> filesList) {
        this.files = filesList;
    }

    public VlServer getServer() {
        return this.server;
    }

    public void setServer(VlServer server_given) {
        this.server = server_given;
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass().equals(VlFilesChannel.class)) {
            VlFilesChannel c = (VlFilesChannel)o;
            logger.log(Level.DEBUG, "Comparaison de " + this.getName() + " et " + c.getName());
            return c.name.equals(this.name);
        }
        return false;
    }

    @Override
    public boolean sameGroup(IVlMedia media) {
        if (media.getClass() == VlFilesChannel.class) {
            VlFilesChannel c = (VlFilesChannel)media;
            return c.getServer().equals(this.getServer());
        }
        return false;
    }

    @Override
    public boolean belongsToGroup(VlMediaGroup group) {
        if (!group.medias.isEmpty()) {
            return this.sameGroup(group.medias.get(0));
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(IVlMedia other) {
        if (other.getClass().equals(VlFilesChannel.class)) {
            VlFilesChannel channel = (VlFilesChannel)other;
            return this.name.compareTo(channel.getName());
        }
        return -1;
    }

    public int getId() {
        return this.hashCode();
    }
}

