/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.model;


/**
 * A DVB-T card.
 *
 * @author Sylvain Cadilhac <sylv at videolan.org>
 */
public class DVBTAdapter extends Adapter {

    private static final long serialVersionUID = -3906573448360679578L;

    public String getType() {
        return DTT;
    }

    @Override
    public boolean canRead(Media media) {
        return media.getClass().equals(DTTChannel.class);
    }

}
